;/ CostumButtons 2
;/    GPI - 28.07.2003
;/
;/ The black color (rgb(0,0,0)) is set as transparent
;/ so when you want a black boarder, use rgb(1,1,1) instead of rgb(0,0,0)
;/
;/ because the buttons ARE normal buttons, you can use
;/ DisableGadget()
;/ SetGadgetFont()
;/ Also you can use the normal PB-Message-System with WaitWindowEvent() and #PB_Event_Button
;/
;/ SetGadgetText() won't work, use SetCostumButtonText()
;/ same for SetGadgetState() and GetGadgetState(), use SetCostumButtonState() and GetCostumButtonState()
;/ ResizeGadgetText() has problems with the background, so use ResizeCostumButton()
;/
;/ Original Costum Buttons by freedimension

;-
#CostumBotton_Toggle=1
#CostumBotton_CheckBox=2
#CostumBotton_Option=4

Global CButton_OptionOffset_
Structure CostumButton
  id.l
  hwnd.l
  text.s
  NormalTColor.l
  FocusTColor.l
  PressedTcolor.l
  DisabledTcolor.l
  normal.l
  focus.l
  pressed.l
  PFocus.l
  disabled.l
  state.l
  Type.l
  OptionOffset.l
EndStructure
NewList CButton_.CostumButton()
Procedure FreeCostumButton(id)
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        FreeGadget(id)
        CButton_()\text=""
        DeleteElement(CButton_())
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
EndProcedure
Procedure FreeAllCostumButton()
  While FirstElement(CButton_())
    FreeCostumButton(CButton_()\id)
  Wend
EndProcedure

Procedure CostumButton(id,x,y,w,h,text.s,NormalTColor,FocusTColor,PressedTcolor,DisabledTcolor,FontId,normal,focus,pressed,PFocus,disabled,Type); for tcolor and fontid you can use -1 (#pb_default) for Systemdefaults
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        FreeCostumButton(id)
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
  AddElement(CButton_())
  CButton_()\id=id
  CButton_()\text=text
  CButton_()\NormalTColor=NormalTColor
  CButton_()\FocusTColor=FocusTColor
  CButton_()\PressedTcolor=PressedTcolor
  CButton_()\DisabledTcolor=DisabledTcolor
  CButton_()\normal  =normal
  CButton_()\focus   =focus
  CButton_()\pressed =pressed
  CButton_()\PFocus  =PFocus
  CButton_()\disabled=disabled
  CButton_()\Type    =Type
  CButton_()\OptionOffset=CButton_OptionOffset_
  CButton_()\hwnd=ButtonGadget(id,x,y,w,h,"",#BS_OWNERDRAW|$4000);bs_notify
  SetGadgetFont(id,FontId)
  ProcedureReturn CButton_()\hwnd
EndProcedure  
Procedure SetCostumButtonImage(id,normal,focus,pressed,PFocus,disabled) ; -1=no change!
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        If normal<>-1
          CButton_()\normal  = normal
        EndIf
        If pressed<>-1
          CButton_()\pressed = pressed
        EndIf
        If focus<>-1
          CButton_()\focus   = focus
        EndIf
        If PFocus<>-1
          CButton_()\PFocus  = PFocus
        EndIf
        If disabled<>-1
          CButton_()\disabled= disabled
        EndIf
        RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
EndProcedure
Procedure SetCostumButtonText(id,text.s)
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        CButton_()\text=text
        RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
EndProcedure
Procedure GetCostumButtonState(id)
  Result=0
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        Result=CButton_()\state
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
  ProcedureReturn Result
EndProcedure
Procedure SetCostumButtonState(id,state)
  If state: state=1 : EndIf
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        CButton_()\state=state
        RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
EndProcedure
Procedure SetCostumButtonTextColor(id,NormalTColor,FocusTColor,PressedTcolor,DisabledTcolor); -1=Default: -2=nochange
  ResetList(CButton_())
  ok=#False
  Repeat
    If NextElement(CButton_())
      If CButton_()\id=id
        If NormalTColor>-2
          CButton_()\NormalTColor=NormalTColor
        EndIf
        If FocusTColor>-2
          CButton_()\FocusTColor=FocusTColor
        EndIf
        If PressedTcolor>-2
          CButton_()\PressedTcolor=PressedTcolor
        EndIf
        If DisabledTcolor>-2
          CButton_()\DisabledTcolor=DisabledTcolor
        EndIf
        RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
        ok=#True
      EndIf
    Else
      ok=#True
    EndIf
  Until ok
EndProcedure
Procedure ResizeCostumButton(id,x,y,w,h)
  If GetFocus_()=GadgetID(id)
    ok=#True
  EndIf
  HideGadget(id,#True)
  ResizeGadget(id,x,y,w,h)
  HideGadget(id,#False)
  If ok
    SetFocus_(GadgetID(id))
  EndIf
EndProcedure
Procedure StartCostumButtonOption()
  CButton_OptionOffset_+1
EndProcedure
;-
Procedure Callback(WindowID, Message, wParam, lParam) 
  Result = #PB_ProcessPureBasicEvents 
  If Message = #wm_command And wParam>>16&$ffff=#bn_clicked
    ResetList(CButton_())
    ok=#False
    Repeat
      If NextElement(CButton_())
        If CButton_()\hwnd=lParam
          
          If CButton_()\Type&#CostumBotton_Option
            id          =CButton_()\id
            OptionOffset=CButton_()\OptionOffset
            CButton_()\state=1
            RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
            ResetList(CButton_())
            While NextElement(CButton_())
              If CButton_()\Type=#CostumBotton_Option And CButton_()\OptionOffset=OptionOffset And CButton_()\id<>id And CButton_()\state
                CButton_()\state=0
                RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
              EndIf
            Wend
          ElseIf CButton_()\Type&(#CostumBotton_Toggle|#CostumBotton_CheckBox)
            CButton_()\state=1-CButton_()\state
            RedrawWindow_(CButton_()\hwnd, 0, 0,#RDW_INTERNALPAINT|#RDW_INVALIDATE|#RDW_ALLCHILDREN )
          EndIf
          ok=#True
        EndIf
      Else 
        ok=#True
      EndIf
    Until ok
  EndIf
      
  If Message = #WM_DRAWITEM 
    *dis.DRAWITEMSTRUCT = lParam 
    If *dis\CtlType=#ODT_BUTTON	
      ResetList(CButton_())
      ok=#False
      Repeat
        If NextElement(CButton_())
          If CButton_()\hwnd=*dis\hwndItem
            pic=CButton_()\normal
            TColor=CButton_()\NormalTColor
            If *dis\itemState & #ODS_Disabled
              ;{Disabled
              pic=CButton_()\disabled
              If CButton_()\DisabledTcolor>-1
                TColor=CButton_()\DisabledTcolor
              EndIf
              ;}
            ElseIf CButton_()\Type=#CostumBotton_Toggle
              ;{Toggle-Button
              state=CButton_()\state
              If *dis\itemState & #ODS_SELECTED: state=1-state : EndIf
              
              If state=0
                If *dis\itemState & #ODS_FOCUS
                  pic=CButton_()\focus
                  If CButton_()\FocusTColor>-1
                    TColor=CButton_()\FocusTColor
                  EndIf
                EndIf
              Else
                If *dis\itemState & #ODS_FOCUS
                  pic=CButton_()\PFocus
                  If CButton_()\FocusTColor>-1
                    TColor=CButton_()\FocusTColor
                  EndIf
                Else
                  pic=CButton_()\pressed
                  If CButton_()\FocusTColor>-1
                    TColor=CButton_()\FocusTColor
                  EndIf
                EndIf
              EndIf
              ;}
            ElseIf CButton_()\Type&(#CostumBotton_CheckBox|#CostumBotton_Option)
              ;{Checkbox
              If *dis\itemState & #ODS_FOCUS
                If CButton_()\FocusTColor>-1
                  TColor=CButton_()\FocusTColor
                EndIf
              EndIf
              state=CButton_()\state
              If state=0
                If *dis\itemState & #ODS_SELECTED
                  pic=CButton_()\focus
                EndIf
              Else
                If *dis\itemState & #ODS_SELECTED
                  pic=CButton_()\PFocus
                Else
                  pic=CButton_()\pressed
                EndIf
              EndIf
              ;}
            ElseIf *dis\itemState & #ODS_SELECTED 
              ;{normal
              pic=CButton_()\PFocus
              If CButton_()\PressedTcolor>-1
                TColor=CButton_()\PressedTcolor
              EndIf
            ElseIf *dis\itemState & #ODS_FOCUS 
              pic=CButton_()\focus
              If CButton_()\FocusTColor>-1
                TColor=CButton_()\FocusTColor
              EndIf
              ;}
            EndIf
            
            oldmode=SetBkMode_(*dis\hDC, #TRANSPARENT)
            
            point.POINT\x=0:point\y=0
            MapWindowPoints_(GetParent_(CButton_()\hwnd),CButton_()\hwnd,point,1)
            
            BackBrush=GetClassLong_(WindowID(), #GCL_HBRBACKGROUND)
            SetBrushOrgEx_(*dis\hDC,point\x,point\y,oldpoint.POINT)
            FillRect_(*dis\hDC,*dis\rcItem,BackBrush)
            SetBrushOrgEx_(*dis\hDC,oldpoint\x,oldpoint\y,0)
            
            GetObject_(pic,SizeOf(BITMAP),bmp.BITMAP)
            
            If pic
              imglist=ImageList_Create_(bmp\bmWidth,bmp\bmHeight,#ILC_COLORDDB|#ILC_MASK,1,0) 
              ImageList_AddMasked_(imglist,pic,0)
              ImageList_Draw_(imglist,0,*dis\hDC,*dis\rcItem\left,*dis\rcItem\top,#ILD_TRANSPARENT	) 
              ImageList_Destroy_(imglist) 
            EndIf
            
            
            GetTextExtentPoint32_(*dis\hDC,@CButton_()\text,Len(CButton_()\text),size.SIZE)
            
            h=((*dis\rcItem\bottom-*dis\rcItem\top      )-size\cy)/2
            
            If CButton_()\Type&( #CostumBotton_CheckBox|#CostumBotton_Option)
              w=bmp\bmWidth+2
              
              If *dis\itemState & #ODS_FOCUS
                hpen=createpen_(#PS_DOT,1,TColor)
                SelectObject_(*dis\hDC,hpen)
                x1=*dis\rcItem\left+w-1
                y1=*dis\rcItem\top+h-1
                x2=*dis\rcItem\left+w+size\cx+1
                y2=*dis\rcItem\top+h+size\cy+1 
                movetoex_(*dis\hDC,x1,y1,oldpoint.POINT)
                lineto_(*dis\hDC,x2,y1)
                lineto_(*dis\hDC,x2,y2)
                lineto_(*dis\hDC,x1,y2)
                lineto_(*dis\hDC,x1,y1)
                
                DeleteObject_(hpen)
              EndIf
              
              
            Else
              w=((*dis\rcItem\right -*dis\rcItem\left)-size\cx)/2
            EndIf 
            
            
             
            If TColor>-1
              SetTextColor_(*dis\hDC, TColor)
            EndIf
            
            TextOut_(*dis\hDC,*dis\rcItem\left+w,*dis\rcItem\top+h,@CButton_()\text,Len(CButton_()\text))
            SetBkMode_(*dis\hDC,oldmode)
            
            
            Result=#True
            ok=#True
          EndIf
        Else
          ok=#True
        EndIf
      Until ok
    EndIf
  EndIf
  ProcedureReturn Result 
EndProcedure 

OpenWindow(1, 10, 150, 256, 256, #PB_Window_TitleBar|#PB_Window_SystemMenu, "Button OwnerDraw") 

SetWindowCallback(@Callback()) 

normal   = LoadImage(1, "lang-normal.bmp") 
focus    = LoadImage(2, "lang-normal-focus.bmp") 
pressed  = LoadImage(3, "lang-pressed.bmp") 
disabled = LoadImage(4, "lang-disabled.bmp") 
PFocus   = LoadImage(5, "lang-pressed-focus.bmp")
back     = LoadImage(6, "background2.bmp")

chk_normal  = LoadImage( 7,"check-normal.bmp")
chk_Pnormal = LoadImage( 8,"check-normal-pressed.bmp")
chk_checked = LoadImage( 9,"check-checked.bmp")
chk_Pchecked= LoadImage(10,"check-checked-pressed.bmp")
chk_disabled= LoadImage(11,"check-disabled.bmp")

opt_normal  = LoadImage(12,"option-normal.bmp")
opt_Pnormal = LoadImage(13,"option-normal-pressed.bmp")
opt_select  = LoadImage(14,"option-select.bmp")
opt_Pselect = LoadImage(15,"option-select-pressed.bmp")
opt_disabled= LoadImage(16,"option-disabled.bmp")


 BackBrush= CreatePatternBrush_(back) 
 SetClassLong_(WindowID(), #GCL_HBRBACKGROUND, BackBrush)

CreateGadgetList(WindowID()) 


CostumButton(1,  5,     5,100, 20,"Button 1",RGB(255,255,255),#PB_Default   ,#PB_Default   ,#PB_Default     ,LoadFont(1,"Courier New",10) , normal,focus ,pressed,PFocus,disabled,0) 
CostumButton(2,  5,25*1+5,100, 20,"unpressed",RGB(255,255,255),#PB_Default   ,RGB(0,0,0)    ,#PB_Default     ,         #PB_Default         , normal,focus ,pressed,PFocus,disabled,#CostumBotton_Toggle) 
CostumButton(3,  5,25*2+5,100, 20,"Disabled",RGB(255,255,255),RGB(255,255,0),RGB(128,128,0),RGB(0,0,0)      ,         #PB_Default         , normal,focus ,pressed,PFocus,disabled,Type) 
CostumButton(4,  5,25*3+5,100, 20,"uncheck" ,RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,chk_normal,chk_Pnormal,chk_checked,chk_Pchecked,chk_disabled,#CostumBotton_CheckBox)
StartCostumButtonOption()
CostumButton(5,  5,25*4+5,100, 20,"Option 1",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)
CostumButton(6,  5,25*5+5,100, 20,"Option 1",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)
CostumButton(7,  5,25*6+5,100, 20,"Option 1",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)
StartCostumButtonOption()
CostumButton(8,  5,25*7+5,100, 20,"Option 2",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)
CostumButton(9,  5,25*8+5,100, 20,"Option 2",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)
CostumButton(10, 5,25*9+5,100, 20,"Option 2",RGB(255,255,255),RGB(255,255,0),RGB(255,255,0),RGB(128,128,128),         #PB_Default         ,opt_normal,opt_Pnormal,opt_select ,opt_Pselect ,opt_disabled,#CostumBotton_Option)

;ButtonGadget(4,  5,200,100, 20,"Button 4",#PB_Button_Toggle)

;SetGadgetFont(1,LoadFont(1,"Courier New",10))
DisableGadget(3,#True)
SetCostumButtonState(5,#True)
SetCostumButtonState(8,#True)


Repeat 
  event = WaitWindowEvent() 
  If event=#PB_Event_Gadget
    ;Debug "Pressed"
    If EventType()=#PB_EventType_LeftClick
      Select EventGadgetID()
        Case 2
          SetCostumButtonText(2, StringField("unpressed pressed",GetCostumButtonState(2)+1," "))
        Case 4
          SetCostumButtonText(4, StringField("unchecked checked",GetCostumButtonState(4)+1," "))
      EndSelect
    EndIf
  EndIf
Until event = #PB_Event_CloseWindow 

DeleteObject_(BackBrush)
FreeAllCostumButton() 
; jaPBe Version=1.3.7.21
; FoldLines=00170027002900380039003E003F005D005E007A007B0089008A0099009A00A9
; FoldLines=00AA00C300C400CE00CF00D100D3018500FF0000010600000120000001340000
; Language=0x0000 Language Neutral
; FirstLine=0
; CursorPosition=1
; EnableXP
; ExecutableFormat=Windows
; EOF