;----------------------------------------------------------------------------
;- Object:  SysColor Requester
;- Version: Version 1.2 (may, 2006)
;- Author:  flype (flype44@hotmail.fr)
;- Requir:  Purebasic 4.0+
;----------------------------------------------------------------------------


Macro SUBLANGID(lgid)
  ((lgid)>>10)  
EndMacro
Macro PRIMARYLANGID(lgid)
  ((lgid)&$3FF)  
EndMacro
Macro MAKELANGID(primary, sublang)
  (((sublang)<<10)|(primary))
EndMacro


;----------------------------------------------------------------------------
;- LANGUAGES: STRINGS TABLE
;----------------------------------------------------------------------------

Global Dim lang.s(10)

Select PRIMARYLANGID( GetUserDefaultLangID_() )
  
  Case #LANG_FRENCH
    lang(00) = "Slecteur de couleurs systme"
    lang(01) = "Copier dans le presse-papier"
    lang(02) = "Slecteur de couleurs"
    lang(03) = "Annuler"
    lang(04) = "Aperu"
    lang(05) = "Constante"
    lang(06) = "Copier comme $BBGGRR"
    lang(07) = "Copier comme $RRGGBB"
    lang(08) = "Copier comme RGB(r,g,b)"
    lang(09) = " propos..."
    
  Case #LANG_GERMAN 
    lang(00) = "SysColor Requester" 
    lang(01) = "Kopieren" 
    lang(02) = "Color-Requester" 
    lang(03) = "Abbrechen" 
    lang(04) = "Farbe" 
    lang(05) = "Konstante" 
    lang(06) = "Als $BBGGRR kopieren" 
    lang(07) = "Als $RRGGBB kopieren" 
    lang(08) = "Als RGB(r,g,b) kopieren"
    lang(09) = "About"
    
  Case #LANG_SPANISH
    lang(00) = "Selector de colores del sistema"
    lang(01) = "Copiar al portapapeles"
    lang(02) = "Selector de colores"
    lang(03) = "Cancelar"
    lang(04) = "Color"
    lang(05) = "Constante"
    lang(06) = "Copiar como $BBGGRR"
    lang(07) = "Copiar como $RRGGBB"
    lang(08) = "Copiar como RGB(r,g,b)"
    lang(09) = "About"
    
  Default
    lang(00) = "SysColor Requester"
    lang(01) = "Copy to clipboard"
    lang(02) = "Color Requester"
    lang(03) = "Cancel"
    lang(04) = "Color"
    lang(05) = "Constant"
    lang(06) = "Copy as $BBGGRR"
    lang(07) = "Copy as $RRGGBB"
    lang(08) = "Copy as RGB(r,g,b)"
    lang(09) = "About"
    
EndSelect

;----------------------------------------------------------------------------
;- LANGUAGES: HELP TABLE
;----------------------------------------------------------------------------

Global Dim help.s(30)

Select PRIMARYLANGID( GetUserDefaultLangID_() )
  
  Case #LANG_FRENCH
    help(#COLOR_3DDKSHADOW             ) = "Couleur de l'ombre (sombre) pour l'affichage des lments 3D."
    help(#COLOR_3DFACE                 ) = "Couleur de remplissage pour l'affichage des lments 3D."
    help(#COLOR_3DHIGHLIGHT            ) = "Couleur de mise en valeur pour l'affichage des lments 3D."
    help(#COLOR_3DHILIGHT              ) = "Couleur de mise en valeur pour l'affichage des lments 3D."
    help(#COLOR_3DLIGHT                ) = "Couleur claire pour l'affichage des lments 3D."
    help(#COLOR_3DSHADOW               ) = "Couleur de l'ombre pour l'affichage des lments 3D."
    help(#COLOR_ACTIVEBORDER           ) = "Couleur du bord des fentres actives."
    help(#COLOR_ACTIVECAPTION          ) = "Couleur de la barre de titre des fentres actives."
    help(#COLOR_APPWORKSPACE           ) = "Couleur de l'arrire-plan des fentres MDI."
    help(#COLOR_BACKGROUND             ) = "Couleur de l'arrire-plan du bureau."
    help(#COLOR_BTNFACE                ) = "Couleur de remplissage des boutons."
    help(#COLOR_BTNHIGHLIGHT           ) = "Couleur de mise en valeur des boutons."
    help(#COLOR_BTNSHADOW              ) = "Couleur de l'ombre des boutons."
    help(#COLOR_BTNTEXT                ) = "Couleur du texte des boutons appuys."
    help(#COLOR_CAPTIONTEXT            ) = "Couleur du texte dans divers lments (flches des ascenseurs, par ex)."
    help(#COLOR_DESKTOP                ) = "Couleur de l'arrire-plan du bureau."
    help(#COLOR_GRADIENTACTIVECAPTION  ) = "Couleur de droite du dgrad de la barre de titre des fentre actives."
    help(#COLOR_GRADIENTINACTIVECAPTION) = "Couleur de droite du dgrad de la barre de titre des fentre inactives."
    help(#COLOR_GRAYTEXT               ) = "Couleur des textes griss."
    help(#COLOR_HIGHLIGHT              ) = "Couleur des lments slectionns des gadgets."
    help(#COLOR_HIGHLIGHTTEXT          ) = "Couleur du texte des lments slectionns des gadgets."
    help(#COLOR_HOTLIGHT               ) = "Couleur des liens hypertextes ou les lements dj visits."
    help(#COLOR_INACTIVEBORDER         ) = "Couleur du bord des fentres actives."
    help(#COLOR_INACTIVECAPTION        ) = "Couleur du bord des fentres inactives."
    help(#COLOR_INACTIVECAPTIONTEXT    ) = "Couleur du texte des lments griss."
    help(#COLOR_INFOBK                 ) = "Couleur de l'arrire-plan dans les bulles d'aide."
    help(#COLOR_INFOTEXT               ) = "Couleur du texte dans les bulles d'aide."
    help(#COLOR_MENU                   ) = "Couleur de l'arrire-plan des menus."
    help(#COLOR_MENUHILIGHT            ) = "Couleur de mise en valeur des lments des menus."
    help(#COLOR_MENUBAR                ) = "Couleur de l'arrire-plan des menus lorsque le menu  le style 'flat'."
    help(#COLOR_MENUTEXT               ) = "Couleur du texte des menus."
    help(#COLOR_SCROLLBAR              ) = "Couleur de la zne grise des ascenseurs."
    help(#COLOR_WINDOW                 ) = "Couleur de l'arrire-plan des fentres."
    help(#COLOR_WINDOWFRAME            ) = "Couleur des cadres dans les fentres."
    help(#COLOR_WINDOWTEXT             ) = "Couleur du texte dans les fentres."
               
  Case #LANG_SPANISH
    help(#COLOR_3DDKSHADOW             ) = "Sombra oscura para elementos de display tridimensionales."
    help(#COLOR_3DFACE                 ) = "Color de cara para elementos de display tridimensionales y para el fondo de las cajas de dilogo."
    help(#COLOR_3DHIGHLIGHT            ) = "Color de resaltado para los elementos de display tridimensionales (para el punto de iluminacin)."
    help(#COLOR_3DHILIGHT              ) = "Color de resaltado para los elementos de display tridimensionales (para el punto de iluminacin)."
    help(#COLOR_3DLIGHT                ) = "Color de iluminacin para los elementos de display tridimensionales (para los bordes de iluminacin)."
    help(#COLOR_3DSHADOW               ) = "Color de sombra para los elementos de display tridimensionales (para los bordes del lado opuesto del punto de iluminacin)."
    help(#COLOR_ACTIVEBORDER           ) = "Borde de la ventana activa."
    help(#COLOR_ACTIVECAPTION          ) = "Barra de ttulo de la ventana activa."
    help(#COLOR_APPWORKSPACE           ) = "Color de fondo para aplicaciones del tipo MDI."
    help(#COLOR_BACKGROUND             ) = "Escritorio."
    help(#COLOR_BTNFACE                ) = "Color de cara para los elementos de display tridimensionales y para los fondos de las cajas de dilogo."
    help(#COLOR_BTNHIGHLIGHT           ) = "Color de resaltado para los elementos de display tridimensionales (para el punto de iluminacin)."
    help(#COLOR_BTNSHADOW              ) = "Color de sombra para elementos tridimensionales (para los bordes del lado opuesto del punto de iluminacin)"
    help(#COLOR_BTNTEXT                ) = "Texto en botones del tipo: push."
    help(#COLOR_CAPTIONTEXT            ) = "Texto en subttulos, size box y en la cruz de la barra de desplazamiento."
    help(#COLOR_DESKTOP                ) = "Escritorio."
    help(#COLOR_GRADIENTACTIVECAPTION  ) = "Color del lado derecho del degrade en la barra de titulo de una ventana activa. #COLOR_ACTIVECAPTION Especifica el color del lado izquierdo. Use SPI_GETGRADIENTCAPTIONS Con la funcin: SystemParametersInfo Para determinar si el efecto de degrade se encuentra habilitado."
    help(#COLOR_GRADIENTINACTIVECAPTION) = "Color del lado derecho del degrade en la barra de titulo de una ventana inactiva. #COLOR_INACTIVECAPTION Especifica el color del lado izquierdo."
    help(#COLOR_GRAYTEXT               ) = "Texto gris (deshabilitado). Este color se define en 0 Si el driver del display actual no soporta el color gris slido"
    help(#COLOR_HIGHLIGHT              ) = "Item(s) Seleccionados en un control."
    help(#COLOR_HIGHLIGHTTEXT          ) = "Texto de/los item(s) seleccionados en el control."
    help(#COLOR_HOTLIGHT               ) = "Color para un enlace o item del tipo: hot-tracked."
    help(#COLOR_INACTIVEBORDER         ) = "Borde de una ventana inactiva."
    help(#COLOR_INACTIVECAPTION        ) = "Subttulo de una ventana inactiva."
    help(#COLOR_INACTIVECAPTIONTEXT    ) = "Color del texto en un subttulo inactivo."
    help(#COLOR_INFOBK                 ) = "Color de fondo para los controles del tipo tooltip."
    help(#COLOR_INFOTEXT               ) = "Color del texto para controles del tipo tooltip."
    help(#COLOR_MENU                   ) = "Fondo del Men."
    help(#COLOR_MENUHILIGHT            ) = "El color utilizado para resaltar los items del men cuando el men aparece como un menu flat."
    help(#COLOR_MENUBAR                ) = "El color de fondo para la barra de men cuando los mens aparecen planos (ver SystemParametersInfo). El item seleccionado del men es delineado con #COLOR_HIGHLIGHT."
    help(#COLOR_MENUTEXT               ) = "Texto en Men (Ver: SystemParametersInfo). De todos modos, #COLOR_MENU especifica el color de fondo del men popup."
    help(#COLOR_SCROLLBAR              ) = "rea gris de la barra de desplazamiento."
    help(#COLOR_WINDOW                 ) = "Fondo de la Ventana."
    help(#COLOR_WINDOWFRAME            ) = "Borde de la Ventana."
    help(#COLOR_WINDOWTEXT             ) = "Texto en Windows"
    
  Default
    help(#COLOR_3DDKSHADOW             ) = "Dark shadow for three-dimensional display elements."
    help(#COLOR_3DFACE                 ) = "Face color for three-dimensional display elements and for dialog box backgrounds."
    help(#COLOR_3DHIGHLIGHT            ) = "Highlight color for three-dimensional display elements (for edges facing the light source)."
    help(#COLOR_3DHILIGHT              ) = "Highlight color for three-dimensional display elements (for edges facing the light source)."
    help(#COLOR_3DLIGHT                ) = "Light color for three-dimensional display elements (for edges facing the light source)."
    help(#COLOR_3DSHADOW               ) = "Shadow color for three-dimensional display elements (for edges facing away from the light source)."
    help(#COLOR_ACTIVEBORDER           ) = "Active window border."
    help(#COLOR_ACTIVECAPTION          ) = "Active window title bar."
    help(#COLOR_APPWORKSPACE           ) = "Background color of multiple document Interface (MDI) applications."
    help(#COLOR_BACKGROUND             ) = "Desktop."
    help(#COLOR_BTNFACE                ) = "Face color for three-dimensional display elements and for dialog box backgrounds."
    help(#COLOR_BTNHIGHLIGHT           ) = "Highlight color for three-dimensional display elements (for edges facing the light source)."
    help(#COLOR_BTNSHADOW              ) = "Shadow color for three-dimensional display elements (for edges facing away from the light source)."
    help(#COLOR_BTNTEXT                ) = "Text on push buttons."
    help(#COLOR_CAPTIONTEXT            ) = "Text in caption, size box, and scroll bar arrow box."
    help(#COLOR_DESKTOP                ) = "Desktop."
    help(#COLOR_GRADIENTACTIVECAPTION  ) = "Right side color in the color gradient of an active window's title bar. #COLOR_ACTIVECAPTION specifies the left side color. Use SPI_GETGRADIENTCAPTIONS with the SystemParametersInfo function to determine whether the gradient effect is enabled."
    help(#COLOR_GRADIENTINACTIVECAPTION) = "Right side color in the color gradient of an inactive window's title bar. #COLOR_INACTIVECAPTION specifies the left side color."
    help(#COLOR_GRAYTEXT               ) = "Grayed (disabled) text. This color is set to 0 If the current display driver does not support a solid gray color."
    help(#COLOR_HIGHLIGHT              ) = "Item(s) selected in a control."
    help(#COLOR_HIGHLIGHTTEXT          ) = "Text of item(s) selected in a control."
    help(#COLOR_HOTLIGHT               ) = "Color for a hyperlink or hot-tracked item."
    help(#COLOR_INACTIVEBORDER         ) = "Inactive window border."
    help(#COLOR_INACTIVECAPTION        ) = "Inactive window caption."
    help(#COLOR_INACTIVECAPTIONTEXT    ) = "Color of text in an inactive caption."
    help(#COLOR_INFOBK                 ) = "Background color for tooltip controls."
    help(#COLOR_INFOTEXT               ) = "Text color for tooltip controls."
    help(#COLOR_MENU                   ) = "Menu background."
    help(#COLOR_MENUHILIGHT            ) = "The color used to highlight menu items when the menu appears as a flat menu"
    help(#COLOR_MENUBAR                ) = "The background color for the menu bar when menus appear as flat menus (see SystemParametersInfo). The highlighted menu item is outlined with #COLOR_HIGHLIGHT."
    help(#COLOR_MENUTEXT               ) = "Text in menus (see SystemParametersInfo). However, #COLOR_MENU continues to specify the background color of the menu popup."
    help(#COLOR_SCROLLBAR              ) = "Scroll bar gray area."
    help(#COLOR_WINDOW                 ) = "Window background"
    help(#COLOR_WINDOWFRAME            ) = "Window frame."
    help(#COLOR_WINDOWTEXT             ) = "Text in windows."
         
EndSelect


; IDE Options = PureBasic v4.00 - Beta 11 (Windows - x86)
; CursorPosition = 183
; FirstLine = 130
; Folding = 5
; UseMainFile = SysColorRequester.pb
; Executable = SysColorRequester.exe