;----------------------------------------------------------------------------
;- Object:  SysColor Requester
;- Version: Version 1.2 (may, 2006)
;- Author:  flype (flype44@hotmail.fr)
;- Requir:  Purebasic 4.0+
;----------------------------------------------------------------------------
;- Licence: Feel free to modify/use/share.
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;- Meta-Informations
;----------------------------------------------------------------------------

#TITLE = "SysColor Requester"
#AUTHOR = "flype (flype44@hotmail.fr)"
#VERSION = "1"
#REVISION = "3"

;----------------------------------------------------------------------------
;- Includes
;----------------------------------------------------------------------------

XIncludeFile "SysColorRequester_i18n.pb"

;----------------------------------------------------------------------------
;- Constantes
;----------------------------------------------------------------------------

Enumeration ; margins
  #EC_LEFTMARGIN = 1
  #EC_RIGHTMARGIN = 2
EndEnumeration
Enumeration ; syscolor
  #COLOR_SCROLLBAR               = 0
  #COLOR_DESKTOP                 = 1
  #COLOR_BACKGROUND              = 1
  #COLOR_ACTIVECAPTION           = 2
  #COLOR_INACTIVECAPTION         = 3
  #COLOR_MENU                    = 4
  #COLOR_WINDOW                  = 5
  #COLOR_WINDOWFRAME             = 6
  #COLOR_MENUTEXT                = 7
  #COLOR_WINDOWTEXT              = 8
  #COLOR_CAPTIONTEXT             = 9
  #COLOR_ACTIVEBORDER            = 10
  #COLOR_INACTIVEBORDER          = 11
  #COLOR_APPWORKSPACE            = 12
  #COLOR_HIGHLIGHT               = 13
  #COLOR_HIGHLIGHTTEXT           = 14
  #COLOR_BTNFACE                 = 15
  #COLOR_3DFACE                  = 15
  #COLOR_BTNSHADOW               = 16
  #COLOR_3DSHADOW                = 16
  #COLOR_GRAYTEXT                = 17
  #COLOR_BTNTEXT                 = 18
  #COLOR_INACTIVECAPTIONTEXT     = 19
  #COLOR_3DHIGHLIGHT             = 20
  #COLOR_3DHILIGHT               = 20
  #COLOR_BTNHIGHLIGHT            = 20
  #COLOR_3DDKSHADOW              = 21
  #COLOR_3DLIGHT                 = 22
  #COLOR_INFOTEXT                = 23
  #COLOR_INFOBK                  = 24
  #COLOR_HOTLIGHT                = 26
  #COLOR_GRADIENTACTIVECAPTION   = 27
  #COLOR_GRADIENTINACTIVECAPTION = 28
  #COLOR_MENUHILIGHT             = 29
  #COLOR_MENUBAR                 = 30
EndEnumeration
Enumeration ; gadgets
  #gList
  #gHelp
  #gSplit
  #gCopy
  #gRequester
  #gCancel
EndEnumeration

;----------------------------------------------------------------------------
;- Macros
;----------------------------------------------------------------------------

Macro Bgr2Rgb(c)
  ( ((c)&$FF)<<16 | ((c)&$FF00) | ((c)&$FF0000)>>16 )
EndMacro
Macro Rgb2Str(c)
  ( "RGB(" + Str(Red(c)) + "," + Str(Green(c)) + "," + Str(Blue(c)) + ")" )
EndMacro
Macro Rgb2Sys(c)
  ( "GetSysColor_(" + (c) + ")" )
EndMacro
Macro Rgb2Hex(c)
  ( "$" + RSet(Hex(c), 6, "0") )
EndMacro
Macro Rgb2Hex2(c)
  ( "$" + RSet(Hex(Bgr2Rgb(c)), 6, "0") )
EndMacro
Macro MAKELONG(lo, hi)
  ( ((hi)<<16)|(lo) )
EndMacro

Macro Gadget_Style(gadget)
  SetWindowLong_(GadgetID(gadget), #GWL_EXSTYLE, #WS_EX_STATICEDGE)
  SetWindowPos_(GadgetID(gadget), 0, 0, 0, 0, 0, #SWP_NOMOVE|#SWP_NOSIZE|#SWP_NOZORDER|#SWP_FRAMECHANGED)
EndMacro
Macro Window_MakeTool(window)
  SetWindowLong_(WindowID(window), #GWL_EXSTYLE, GetWindowLong_(WindowID(window), #GWL_EXSTYLE)|#WS_EX_TOOLWINDOW)
  SetWindowPos_(WindowID(window), 0, 0, 0, 0, 0, #SWP_NOMOVE|#SWP_NOSIZE|#SWP_NOZORDER|#SWP_FRAMECHANGED)
EndMacro
Macro Window_ShowHelp(window)
  SetWindowLong_(WindowID(window), #GWL_EXSTYLE, GetWindowLong_(WindowID(window), #GWL_EXSTYLE)|#WS_EX_CONTEXTHELP)
  SetWindowPos_(WindowID(window), 0, 0, 0, 0, 0, #SWP_NOMOVE|#SWP_NOSIZE|#SWP_NOZORDER|#SWP_FRAMECHANGED)
EndMacro
Macro Editor_WordWrap(gadget)
  SendMessage_(GadgetID(gadget), #EM_SETTARGETDEVICE, #Null, #Null)
EndMacro
Macro Editor_SetMargins(gadget, left, right)
  SendMessage_(GadgetID(gadget), #EM_SETMARGINS, #EC_LEFTMARGIN|#EC_RIGHTMARGIN, MAKELONG(left, right))
EndMacro
Macro StatusBar_GetText(statusbar, field, lpString)
  SendMessage_(StatusBarID(statusbar), #SB_GETTEXT, field, lpString)
EndMacro
Macro StatusBar_OwnerDraw(statusbar, field, itemData)
  SendMessage_(StatusBarID(statusbar), #SB_SETTEXT, field|#SBT_OWNERDRAW, itemData)
EndMacro

;----------------------------------------------------------------------------
;- Procedures
;----------------------------------------------------------------------------

Global MaxScale.l

Procedure.l SysColor_About()
  
  Protected about.s
  
  about = #TITLE + #LF$
  about + "Version " + #VERSION + "." + #REVISION
  about + FormatDate(", %yyyy-%mm-%dd",#PB_Compiler_Date) + #LF$ + #LF$
  about + #AUTHOR + #LF$
  about + "PureBasic " + StrF(#PB_Compiler_Version, 1)
  
  MessageRequester(lang(9), about, #MB_ICONINFORMATION)
  
EndProcedure
Procedure.l SysColor_Callback(hWnd.l, uMsg.l, wParam.l, lParam.l)
  
  Protected *pMinMax.MINMAXINFO
  Protected *pItem.DRAWITEMSTRUCT
  Protected lResult.l = #PB_ProcessPureBasicEvents
  
  Select uMsg
    
    Case #WM_HELP
      lResult = SysColor_About()
      
    Case #WM_DRAWITEM
      If wParam = GetDlgCtrlID_(StatusBarID(0))
        *pItem = lParam
        InflateRect_(*pItem\rcItem, -5, -2)
        FillRect_(*pItem\hdc, *pItem\rcItem, CreateSolidBrush_(*pItem\itemData))
        FrameRect_(*pItem\hdc, *pItem\rcItem, GetStockObject_(#BLACK_BRUSH))
        InflateRect_(*pItem\rcItem, -1, -1)
        FrameRect_(*pItem\hdc, *pItem\rcItem, GetStockObject_(#WHITE_BRUSH))
        lResult = #True
      EndIf
      
    Case #WM_GETMINMAXINFO
      *pMinMax = lParam
      *pMinMax\ptMaxTrackSize\x = MaxScale
      *pMinMax\ptMinTrackSize\x = MaxScale
      lResult = #False
      
  EndSelect
  
  ProcedureReturn lResult
  
EndProcedure
Procedure.l SysColor_Add(index.l, text.s)
  
  Protected position.l = CountGadgetItems(#gList)
  
  text = #LF$ + text
  text + #LF$ + ReplaceString(Rgb2Str(GetSysColor_(index)),"))",")");workaround before pb4.0 beta12
  text + #LF$ + Rgb2Hex(GetSysColor_(index))
  
  AddGadgetItem(0, position, text)
  SetGadgetItemData(#gList, position, index)
  SetGadgetItemColor(#gList, position, #PB_Gadget_BackColor, GetSysColor_(index), 0)
  SetGadgetItemColor(#gList, position, #PB_Gadget_FrontColor, RGB(146,075,114), 1)
  SetGadgetItemColor(#gList, position, #PB_Gadget_FrontColor, RGB(000,128,000), 2)
  SetGadgetItemColor(#gList, position, #PB_Gadget_FrontColor, RGB(000,000,255), 3)
  
EndProcedure
Procedure.l SysColor_Requester(mode.l)
  
  Static color.l
  Protected value.s, result.s
  
  color = ColorRequester(color)
  
  If color <> -1
    
    Select mode
      Case 1: result = Rgb2Hex(color)
      Case 2: result = Rgb2Hex2(color)
      Case 3: result = Rgb2Str(color)
    EndSelect
    
    Select color
      Case #Black:   value = "#Black"
      Case #Blue:    value = "#Blue"
      Case #Cyan:    value = "#Cyan"
      Case #Gray:    value = "#Gray"
      Case #Green:   value = "#Green"
      Case #Magenta: value = "#Magenta"
      Case #Red:     value = "#Red"
      Case #White:   value = "#White"
      Case #Yellow:  value = "#Yellow"
      Default:       value = ""
    EndSelect
    
    StatusBarText(0, 1, value, #PB_StatusBar_Center)
    StatusBarText(0, 2, result)
    StatusBar_OwnerDraw(0, 0, color)
    DisableGadget(#gCopy, #False)
    
  EndIf
  
EndProcedure
Procedure.l SysColor_Open()
  
  If OpenWindow(0, 0, 0, 480, 440, lang(0), #PB_Window_SystemMenu|#PB_Window_SizeGadget|#PB_Window_ScreenCentered|#PB_Window_Invisible)
    
    SetWindowColor(0, GetSysColor_(#COLOR_WINDOW))
    
    SmartWindowRefresh(0, #True)
    
    MaxScale = WindowWidth(0)
    MaxScale + ( GetSystemMetrics_(#SM_CXSIZEFRAME) * 2 )
    
    If CreatePopupMenu(0)
      AddKeyboardShortcut(0, #PB_Shortcut_Escape, 0)
      MenuItem(1, lang(6))
      MenuItem(2, lang(7))
      MenuBar()
      MenuItem(3, lang(8))
    EndIf
    
    If CreateStatusBar(0, WindowID(0))
      AddStatusBarField(60)
      AddStatusBarField(80)
      AddStatusBarField(400)
    EndIf
    
    If CreateGadgetList(WindowID(0))
      ListIconGadget(#gList, 5, 5, WindowWidth(0)-10, 0, lang(4), 60, #PB_ListIcon_FullRowSelect|#PB_ListIcon_GridLines|#PB_ListIcon_HeaderDragDrop)
      AddGadgetColumn(#gList, 1, lang(5), 195)
      AddGadgetColumn(#gList, 2, "RGB()", 125)
      AddGadgetColumn(#gList, 3, "HEX()",  65)
      EditorGadget(#gHelp, 5, 0, WindowWidth(0)-10, 50, #PB_Editor_ReadOnly)
      Editor_SetMargins(#gHelp, 10, 10)
      Editor_WordWrap(#gHelp)
      Gadget_Style(#gHelp)
      SplitterGadget(#gSplit, 5, 5, WindowWidth(0)-10, 100, #gList, #gHelp, #PB_Splitter_SecondFixed)
      ButtonGadget(#gRequester, 5, 0, 145, 24, lang(2))
      ButtonGadget(#gCopy, 155, 5, 145, 24, lang(1))
      ButtonGadget(#gCancel, WindowWidth(0)-85,  0,  80, 24, lang(3))
      DisableGadget(#gCopy, #True)
    EndIf
    
    SetGadgetColor(#gHelp, #PB_Gadget_BackColor, GetSysColor_(#COLOR_INFOBK))
    SetGadgetColor(#gHelp, #PB_Gadget_FrontColor, GetSysColor_(#COLOR_INFOTEXT))
    
    If LoadFont(0, "Courier New", 8, #PB_Font_HighQuality)
      SetGadgetFont(#gList, FontID(0))
    EndIf
    
    Window_ShowHelp(0)
    StickyWindow(0, #True)
    SetActiveGadget(#gList)
    
    ProcedureReturn #True
    
  EndIf
  
EndProcedure
Procedure.l SysColor_Event()
  
  Protected clipboard.s
  
  HideWindow(0, #False)
  SetWindowCallback(@SysColor_Callback())
  
  Repeat
    
    Select WaitWindowEvent()
      
      Case #PB_Event_CloseWindow
        Break
        
      Case #PB_Event_SizeWindow
        wh = WindowHeight(0) - StatusBarHeight(0) - 29
        ResizeGadget(#gSplit, #PB_Ignore, #PB_Ignore, #PB_Ignore, wh-10)
        ResizeGadget(#gRequester, #PB_Ignore, wh, #PB_Ignore, #PB_Ignore)
        ResizeGadget(#gCopy, #PB_Ignore, wh, #PB_Ignore, #PB_Ignore)
        ResizeGadget(#gCancel, #PB_Ignore, wh, #PB_Ignore, #PB_Ignore)
        
      Case #PB_Event_CloseWindow, #PB_Event_Menu
        Select EventMenu()
          Case 1: SysColor_Requester(1)
          Case 2: SysColor_Requester(2)
          Case 3: SysColor_Requester(3)
          Case 0: Break
        EndSelect
        
      Case #PB_Event_Gadget
        Select EventGadget()
          Case #gList
            Select EventType()
              Case #PB_EventType_Change, #PB_EventType_LeftClick
                item = GetGadgetState(#gList)
                If item <> -1
                  StatusBarText(0, 1, Str(GetGadgetItemData(#gList, item)), #PB_StatusBar_Center)
                  StatusBarText(0, 2, Rgb2Sys(GetGadgetItemText(#gList, item, 1)))
                  StatusBar_OwnerDraw(0, 0, GetGadgetItemColor(#gList, item, #PB_Gadget_BackColor, 0))
                  SetGadgetText(#gHelp, #LF$ + help(GetGadgetItemData(#gList, item)))
                  DisableGadget(#gCopy, #False)
                EndIf
              Case #PB_EventType_LeftDoubleClick
                item = GetGadgetState(#gList)
                If item <> -1
                  SetClipboardText(Rgb2Sys(GetGadgetItemText(#gList, item, 1)))
                  Break
                EndIf
            EndSelect
          Case #gCopy
            If StatusBar_GetText(0, 1, @clipboard)
              SetClipboardText(clipboard)
              Break
            EndIf
          Case #gRequester
            DisplayPopupMenu(0, WindowID(0))
          Case #gCancel
            Break
        EndSelect
        
    EndSelect
    
  ForEver
  
EndProcedure
Procedure.l SysColor_Main()
  
  If SysColor_Open()
    
    SysColor_Add(#COLOR_3DDKSHADOW             , "#COLOR_3DDKSHADOW"             )
    SysColor_Add(#COLOR_3DFACE                 , "#COLOR_3DFACE"                 )
    SysColor_Add(#COLOR_3DHIGHLIGHT            , "#COLOR_3DHIGHLIGHT"            )
    SysColor_Add(#COLOR_3DHILIGHT              , "#COLOR_3DHILIGHT"              )
    SysColor_Add(#COLOR_3DLIGHT                , "#COLOR_3DLIGHT"                )
    SysColor_Add(#COLOR_3DSHADOW               , "#COLOR_3DSHADOW"               )
    SysColor_Add(#COLOR_ACTIVEBORDER           , "#COLOR_ACTIVEBORDER"           )
    SysColor_Add(#COLOR_ACTIVECAPTION          , "#COLOR_ACTIVECAPTION"          )
    SysColor_Add(#COLOR_APPWORKSPACE           , "#COLOR_APPWORKSPACE"           )
    SysColor_Add(#COLOR_BACKGROUND             , "#COLOR_BACKGROUND"             )
    SysColor_Add(#COLOR_BTNFACE                , "#COLOR_BTNFACE"                )
    SysColor_Add(#COLOR_BTNHIGHLIGHT           , "#COLOR_BTNHIGHLIGHT"           )
    SysColor_Add(#COLOR_BTNSHADOW              , "#COLOR_BTNSHADOW"              )
    SysColor_Add(#COLOR_BTNTEXT                , "#COLOR_BTNTEXT"                )
    SysColor_Add(#COLOR_CAPTIONTEXT            , "#COLOR_CAPTIONTEXT"            )
    SysColor_Add(#COLOR_DESKTOP                , "#COLOR_DESKTOP"                )
    SysColor_Add(#COLOR_GRADIENTACTIVECAPTION  , "#COLOR_GRADIENTACTIVECAPTION"  )
    SysColor_Add(#COLOR_GRADIENTINACTIVECAPTION, "#COLOR_GRADIENTINACTIVECAPTION")
    SysColor_Add(#COLOR_GRAYTEXT               , "#COLOR_GRAYTEXT"               )
    SysColor_Add(#COLOR_HIGHLIGHT              , "#COLOR_HIGHLIGHT"              )
    SysColor_Add(#COLOR_HIGHLIGHTTEXT          , "#COLOR_HIGHLIGHTTEXT"          )
    SysColor_Add(#COLOR_HOTLIGHT               , "#COLOR_HOTLIGHT"               )
    SysColor_Add(#COLOR_INACTIVEBORDER         , "#COLOR_INACTIVEBORDER"         )
    SysColor_Add(#COLOR_INACTIVECAPTION        , "#COLOR_INACTIVECAPTION"        )
    SysColor_Add(#COLOR_INACTIVECAPTIONTEXT    , "#COLOR_INACTIVECAPTIONTEXT"    )
    SysColor_Add(#COLOR_INFOBK                 , "#COLOR_INFOBK"                 )
    SysColor_Add(#COLOR_INFOTEXT               , "#COLOR_INFOTEXT"               )
    SysColor_Add(#COLOR_MENU                   , "#COLOR_MENU"                   )
    SysColor_Add(#COLOR_MENUHILIGHT            , "#COLOR_MENUHILIGHT"            )
    SysColor_Add(#COLOR_MENUBAR                , "#COLOR_MENUBAR"                )
    SysColor_Add(#COLOR_MENUTEXT               , "#COLOR_MENUTEXT"               )
    SysColor_Add(#COLOR_SCROLLBAR              , "#COLOR_SCROLLBAR"              )
    SysColor_Add(#COLOR_WINDOW                 , "#COLOR_WINDOW"                 )
    SysColor_Add(#COLOR_WINDOWFRAME            , "#COLOR_WINDOWFRAME"            )
    SysColor_Add(#COLOR_WINDOWTEXT             , "#COLOR_WINDOWTEXT"             )
    
    ProcedureReturn SysColor_Event()
    
  EndIf                                       
  
EndProcedure                                  

;----------------------------------------------------------------------------
;- Main
;----------------------------------------------------------------------------

SysColor_Main()


; IDE Options = PureBasic v4.00 - Beta 11 (Windows - x86)
; CursorPosition = 262
; FirstLine = 51
; Folding = AAAk
; EnableXP
; UseIcon = purebasic.ico
; Executable = SysColorRequester.exe
; DisableDebugger